<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

$download = vB_Template::create('dbtech_downloads_home');

($hook = vBulletinHook::fetch_hook('dbtech_downloads_home_start')) ? eval($hook) : false;

$cats = $vbulletin->dbtech_downloads_categories;

$listings 	= (intval($vbulletin->versionnumber) == 4) ? '<div class="tr">' : '<tr>';

$i			= 0;
$count		= 0;
$hidecats 	= array('0');

foreach ($cats AS $cat)
{
	$permissions 	= unserialize($cat['permissions']);
	
	$canview = false;

	if(is_member_of($vbulletin->userinfo, (array)$permissions['view']))
	{
		$canview = true;
	}

	if (!empty($permissions) && (in_array($vbulletin->userinfo['usergroupid'], $permissions['view']) || $canview == true || Downloads::is_mod()))
	{
		if ($cat['parentid'] == 0)
		{
			$cats = vB_Template::create('dbtech_downloads_home_categories');

			if (empty($cat['filecount'])) $cat['filecount'] = 0;

			$cats->register('cat', $cat);

			$listings .= $cats->render();
			$i++;

			if ($i == 3)
			{
				$listings .= (intval($vbulletin->versionnumber) == 4) ? '</div> <div class="tr">' : '</tr> <tr>';

				$i = 0;
			}
		} else {
			$permissions 	= unserialize($cat['permissions']);
			$secondary	= explode(',', $vbulletin->userinfo['membergroupids']);

			$canview = false;
			foreach ($secondary AS $ugid)
			{
				if (in_array($ugid, (array)$permissions['view']))
				{
					$canview = true;
				}
			}
			
			if (!$cat['catid'] || (!in_array($vbulletin->userinfo['usergroupid'], $permissions['view']) && $canview == false))
			{
				array_push($hidecats, $cat['catid']);
			}
		}
	} else {
		if ($cat['catid'])
		{
			array_push($hidecats, $cat['catid']);
		}
	}
	
	$count++;
}


$listings .= (intval($vbulletin->versionnumber) == 4) ? '</div>' : '</tr>';

 
require_once (DIR . '/includes/class_bbcode.php');
$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

$stats = array();

$filecount = $db->query_first("
	SELECT 
		COUNT(groupid) AS total, 
		SUM(downloads) AS downloads 
	FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
");

$stats['files'] 	= $filecount['total'];
$stats['downloads']	= construct_phrase($vbphrase['dbtech_downloads_files_downloaded_x_times'], intval($filecount['downloads']));

$stats['categories'] = $count;

$welcome = $vbulletin->options['dbtech_downloads_welcome_message'];

$welcome = $bbcode->parse($welcome, 'nonforum', true);

$JAVASCRIPT_INCLUDE .= '
Downloads.init_home_page(' . $vbulletin->userinfo['userid'] . ');
var VBVERSION = ' . intval($vbulletin->versionnumber) . ';
';

($hook = vBulletinHook::fetch_hook('dbtech_downloads_home_complete')) ? eval($hook) : false;

$download->register('welcome', $welcome);
$download->register('stats', $stats);
$download->register('template_hook', $template_hook);
$download->register('listings', $listings);

$HTML .= $download->render();
?>